    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    //usata in tutte le pagine dell'amministrazione quando l'utente vuole cambiare password
    function validazionePassword() {
        var pass  = $('#cambiaPassword').val();
        var pass2 = $('#cambiaPassword2').val();
        if(pass==pass2 && pass!="") {
            document.formCambiaPassword.submit();
        }
        else if(pass=="") {
            alert("il campo password è vuoto");
        }
        else {
            alert("le password devono coincidere");
        }
    }

    //funzione di invio dati. Titolo e testo sono campi obbligatori, se non sono stati inseriti viene visualizzato un messaggio
    function salvaContenuto() {
        if($('#titoloPagina').val()=="") {
            alert("Inserisci il titolo");
        }
        else {
            document.formCreaPagina.submit();
        }
    }
    
    //funzione di invio dati. Titolo e testo sono campi obbligatori, se non sono stati inseriti viene visualizzato un messaggio
    function pubblicaContenuto() {
        if($('#titoloPagina').val()=="") {
            alert("Inserisci il titolo");
        }
        else {
            document.getElementById("statoPubblicato").checked = true;
            document.formCreaPagina.submit();
        }
    }
     
    function eliminaFotoProfilo() {
	$.ajax({
	    type:"POST",
	    url:"utenti/cambiaImmaginiUtente.php",
	    data:{
		operazione:"eliminaFotoProfilo",
	    },
	    success:function(result) {
		if(result=="ok") {
		    document.getElementById("fotoUtente").src="immagini/altro/segnaPostoUtente.png";
		}
	    },
	    error: function() {
		alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
	    }
	});
    }
    
    // funzione per l'invio dell'email
    function invia(moduloContatto,richiediAccettazioneCondizioniPrivacy,urlRedirect) {
        var valida   = true;
        var nomeForm = "form"+moduloContatto;
        var form = document.getElementById(nomeForm);
        var i, j, q = [];
        for (i = form.elements.length - 1; i >= 0; i = i - 1) {
            if (form.elements[i].name === "") {
                continue;
            }
            switch (form.elements[i].nodeName) {
                    case 'INPUT':
                        switch (form.elements[i].type) {
                        case 'text':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'email':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'hidden':
                        case 'password':
                        case 'button':
                        case 'reset':
                        case 'checkbox':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].checked==false) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'radio':
                             if (form.elements[i].checked) {
                                 q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                             }
                             break;
                        }
                        break;
                    case 'file':
                        break;
                    case 'TEXTAREA':
                        if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                            alert("Il campo "+ form.elements[i].name +" è richiesto");
                            valida=false;
                        }
                        else {                            
                           q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                        }
                        break;
                    case 'SELECT':
                        switch (form.elements[i].type) {
                        case 'select-one':
                             q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
                             break;
                        case 'select-multiple':
                             for (j = form.elements[i].options.length - 1; j >= 0; j = j - 1) {
                                 if (form.elements[i].options[j].selected) {
                                     q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].options[j].value));
                                 }
                             }
                             break;
                        }
                        break;
            }
            data = q.join("<br>");
        }

        if(richiediAccettazioneCondizioniPrivacy=="si" && valida==true) {
            var checboxPrivacy = document.getElementById("accettazioneTerminiCondizioni");
            if(checboxPrivacy.checked==false) {            
                alert("Devi accettare le condizioni sulla privacy");
            }
            else {
                if(valida==true) {
                    $.ajax({
                        type:"POST",
                        url:"mail.php",
                        data:"idForm="+moduloContatto+"&informazioniInserite="+data,
                        success:function(risposta) {
                            if(risposta=="ok") {
                                location.href = urlRedirect;
                            }
                            else {
                                alert(risposta);
                            }
                        }
                    });
                }
            }
        }
        else {
            if(valida==true) {
                $.ajax({
                    type:"POST",
                    url:"mail.php",
                    data:"idForm="+moduloContatto+"&informazioniInserite="+data,
                    success:function(risposta) {
                        if(risposta=="ok") {
                            location.href = urlRedirect;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
            }
        }
        
    }

                    /*** FUNZIONI PER EFFETTUARE OPERAZIONI COMUNI ***/

    // funzione per modificare la posizione di un elemento
    // usata per modficare la posizione nelle colonne laterali
    // il campo tabella da aggiornare contiene la tabella da modificare, a seconda del valore
    // lo script modificherà la query di aggiornamento
    function modificaPosizione(tabellaDaAggiornare,idCampoInput,idVoceMenu) {
        var posizione = $('#'+idCampoInput).val();
        location.href = "operazioniComuni/aggiornaPosizione.php?tabellaDaAggiornare="+tabellaDaAggiornare+"&id="+idVoceMenu+"&posizione="+posizione;
    }

    // funzione per modificare il nome di un componente nelle colonne laterali
    // il campo tabella da aggiornare contiene la tabella da modificare, a seconda del valore
    // lo script modificherà la query di aggiornamento
    function modificaNomeComponente(tabellaDaAggiornare,idCampoInput,idVoceMenu) {
        var nomeComponente = $('#'+idCampoInput).val();
        location.href = "operazioniComuni/aggiornaNomeComponente.php?tabellaDaAggiornare="+tabellaDaAggiornare+"&id="+idVoceMenu+"&nomeComponente="+nomeComponente;
    }

    // funzione per modificare il percorso di un prodotto geecom
    // usata in impostazioni -> prodotti installati
    function modificaProdottoGeecom(idCampoInput,idProdotto) {
        var percorso = $('#'+idCampoInput).val();
        location.href = "impostazioni/aggiornaImpostazioniProdotti.php?percorso="+percorso+"&idProdotto="+idProdotto;
    }

    // funzione per modificare il percorso di un prodotto geecom
    // usata in impostazioni -> prodotti installati
    function cookieAccettati() {
        var CookieDate = new Date;
        CookieDate.setFullYear(CookieDate.getFullYear( ) +30);
        document.cookie = "cookieAccettati=si; expires=" + CookieDate.toGMTString( ) + ";";
    }

    /*
     * funzione per aggiornare tramite ajax un campo della tabella impostazioni
     */
    function aggiornaCampoImpostazioni(tabella,id,campo,valore) {
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:"operazione=aggiornaTabellaPersonalizzata"+"&tabella="+tabella+"&id="+id+"&campo="+campo+"&valore="+valore,
            success:function(result) {
                alert(result);
            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    /*
     * funzione per aggiornare tramite ajax le impostazioni sui cookie
     */
    function aggiornaImpostazioniCookie() {
        var attivaBarraCookie = "";
        var mostraPulsanteMaggioriInformazioni = "";
        var mostraPulsanteNonAccetto = "";
        if($('#attivaBarraCookie')[0].checked===true) {
            attivaBarraCookie = "si";
        }
        else {
            attivaBarraCookie = "no";
        }
        
        if($('#mostraPulsanteMaggioriInformazioni')[0].checked===true) {
            mostraPulsanteMaggioriInformazioni = "si";
        }
        else {
            mostraPulsanteMaggioriInformazioni = "no";
        }

        if($('#mostraPulsanteNonAccetto')[0].checked===true) {
            mostraPulsanteNonAccetto = "si";
        }
        else {
            mostraPulsanteNonAccetto = "no";
        }
        
        //var testoBarraCookie = document.getElementById("testoBarraCookie").value;
        var testoBarraCookie = tinymce.activeEditor.getContent();
        var testoPulsanteAccetto = document.getElementById("testoPulsanteAccetto").value;
        var testoPulsanteNonAccetto = document.getElementById("testoPulsanteNonAccetto").value;
        var testoPulsanteMaggioriInformazioni = document.getElementById("testoPulsanteMaggioriInformazioni").value;
        var headCodiciCookie = document.getElementById("headCodiciCookie").value;
        var fineBodyCookie = document.getElementById("fineBodyCookie").value;
        var paginaMaggioriImpostazioni = document.getElementById("paginaMaggioriImpostazioni").value;
        
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:{
                operazione:'aggiornaImpoastazioniCookie',
                attivaBarraCookie:attivaBarraCookie,
                testoBarraCookie:testoBarraCookie,
                testoPulsanteAccetto:testoPulsanteAccetto,
                testoPulsanteNonAccetto:testoPulsanteNonAccetto,
                headCodiciCookie:headCodiciCookie,
                fineBodyCookie:fineBodyCookie,
                testoPulsanteMaggioriInformazioni:testoPulsanteMaggioriInformazioni,
                mostraPulsanteMaggioriInformazioni:mostraPulsanteMaggioriInformazioni,
                mostraPulsanteNonAccetto:mostraPulsanteNonAccetto,
                paginaMaggioriImpostazioni:paginaMaggioriImpostazioni
            },
            success:function(result) {
                alert(result);
            },
            error:function(){
              alert("errore");
            }
        });
    }
    
    /*
     * funzione che aggiorna i click ricevuti da un invito all'azione, e 
     * reindirizza l'utente nella pagina speifica
     */
    function gestisciClick(id, link,tipoOperazione) {
        $.ajax({
            type:"GET",
            url:"controller/controllerImpostazioni.php",
            data:{
                operazione:tipoOperazione,
                id:id
            },
            success:function() {
                location.href = link;
            },
            error:function(){
              alert("errore");
            }
        });
    }
    
    /*
     * funzione per settare i cookie, richiamata dal file nel template leggeCookie.php
     */
    function impostaCookie() {
        document.cookie = "leggecookie=leggecookie";
        location.reload();
    }
    
    /*
     * questa funzione viene usata per eseguire le interazioni miPiace e nonMiPiace
     * per le domande
     */
    function eseguiInterazione(azione,tipo,id) {
        if(tipo=="domanda") {
            var controller = "controllerDomande.php";
        }
        else {
            var controller = "controllerRisposte.php";
        }
        
        $.ajax({
            type:"POST",
            url:"controller/"+controller,
            data:{
                operazione:azione,
                id:id
            },
            success:function(result) {
                location.reload();
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }

    function aggiungiEtichetta(inputSorgente,tipo,divDestinazione) {
        var nome = document.getElementById(inputSorgente).value;
        if(nome=="") {
            alert("Il campo è vuoto");
        }
        else {
            $.ajax({
                type:"POST",
                url:"../controller/controllerEtichette.php",
                data:{
                    operazione:"crea",
                    id:0,
                    nome:nome,
                    tipo:tipo
                },
                success:function(codice) {
                    if(codice=="Errore: esiste già un etichetta con questo nome") {
                        alert("Errore: esiste già un etichetta con questo nome")
                    }
                    else {
                        var codiceHtmlAttuale = document.getElementById(divDestinazione).innerHTML;
                        document.getElementById(divDestinazione).innerHTML = codiceHtmlAttuale + codice;
                    }
                },
                error: function(xhr,status,error) {
                    alert(status+" "+error);
                }
            });
        }
    }
    
    function eliminaEtichetta(id) {

        $.ajax({
            type:"POST",
            url:"../controller/controllerEtichette.php",
            data:{
                operazione:"elimina",
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {                
                    document.getElementById("divEtichetta"+id).className = "d-none";
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function apriPopupEliminaImmagine(idDiv,percorso) {
        document.getElementById("idDiv").value            = idDiv;
        document.getElementById("percorsoImmagine").value = percorso;
        document.getElementById("immagineDaEliminare").src= percorso;
        $('#modalEliminaImmagine').modal('show');
    }
    
    function eliminaImmagine(prefisso) {
        var idDiv    = document.getElementById("idDiv").value;
        var percorso = document.getElementById("percorsoImmagine").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerRisorse.php",
            data:{
                operazione:'eliminaFileRisorsa',
                id:0,
                percorso:percorso
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById(idDiv).className = "d-none";
                    $('#modalEliminaImmagine').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    function apriPopupEliminaFile(idDiv,percorso) {
        document.getElementById("idDivRisorsa").value        = idDiv;
        document.getElementById("percorsoFileRisorsa").value = percorso;
        $('#testoPercorsoFile').text(percorso);
        $('#modalEliminaFile').modal('show');
    }
    
    function eliminaFileRisorsa(prefisso) {
        var idDiv    = document.getElementById("idDivRisorsa").value;
        var percorso = document.getElementById("percorsoFileRisorsa").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerRisorse.php",
            data:{
                operazione:'eliminaFileRisorsa',
                id:0,
                percorso:percorso
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById(idDiv).className = "d-none";
                    $('#modalEliminaFile').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    function segnaNotificaComeLetta(prefisso,id) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerNotifiche.php",
            async:false,
            data:{
                operazione:"segnaComeLetta",
                id:id
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("divNotifica"+id).className = "d-none";
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    function segnaNotificaComeLettaConRedirect(prefisso,id,link) {
        segnaNotificaComeLetta(prefisso,id);
        location.href = link;
    }
    
    function mostraDivNotifiche() {
        document.getElementById("dropdown-notifiche").className = "shadow p-3";
        document.getElementById("campanellaNotifiche").removeEventListener("click", mostraDivNotifiche);
        document.getElementById("campanellaNotifiche").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("main").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("headerAdmin").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("navbarCollapse").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("barraSuperioreAdmin").addEventListener("click", nascondiDivNotifiche);
    }
    
    function nascondiDivNotifiche() {
        document.getElementById("dropdown-notifiche").className = "d-none";
        document.getElementById("campanellaNotifiche").addEventListener("click", mostraDivNotifiche);
        document.getElementById("campanellaNotifiche").removeEventListener("click", nascondiDivNotifiche);
    }
    
    function eseguiModificaPasswordAmministratore(prefisso) {
        var nuovaPassword    = document.getElementById("nuovaPassword").value;
        var confermaPassword = document.getElementById("confermaNuovaPassword").value;
        
        if(nuovaPassword.length==0) {
            alert("Non è possibile impostare una password vuota");
        }
        else if(nuovaPassword==confermaPassword) {
            $.ajax({
                type:"POST",
                url:prefisso+"controller/controllerUtenti.php",
                data:{
                    operazione:'modificaPasswordAmministrazione',
                    nuovaPassword:nuovaPassword
                },
                success:function(esito) {
                    if(esito=="ok") {
                        $('#modalEliminaFile').modal('hide');
                        $('#labelOperazioneCompletata').text("Password cambiata con successo");
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    else {
                        alert(esito);
                    }
                },
                error:function(){
                  alert("errore");
                }
            });
        }
        else {
            alert("Le password devono coincidere");
        }
    }
    
    /*
     * funzione per aggiornare tramite ajax un campo della tabella impostazioni
     */
    function aggiornaCampoImpostazioni(tabella,id,campo,valore) {
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:"operazione=aggiornaCampoTabella"+"&tabella="+tabella+"&id="+id+"&campo="+campo+"&valore="+valore,
            success:function(esito) {
                if(esito!="ok") { // se l'esito ha valore diverso da ok allora c'è qualche problema, e viene mostrato a video
                    alert(esito);
                }
            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    function creaCartella(campoInputNome,campoInputCartellaMadre) {
        var nomeCartella  = document.getElementById(campoInputNome).value;
        var cartellaMadre = document.getElementById(campoInputCartellaMadre).value;

        if(nomeCartella!="") {
            $.ajax({
                type:"POST",
                url:"../controller/controllerCartelle.php",
                data:{
                    operazione:"crea",
                    id:0,
                    cartellaMadre:cartellaMadre,
                    nome:nomeCartella,
                    descrizione:''
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById(campoInputNome).value = "";
                        aggiornaContenutoCartella("");
                        aggiornaAlberoCartella();
                    }
                    else {
                        alert(esito);
                    }
                },
                error: function(xhr,status,error) {
                    alert(status+" "+error);
                }
            });
        }
        else {
            alert("Inserisci il nome della cartella");
        }
    }
    
    function apriModalEliminaCartella(id,nomeCartella) {
        $('#cartellaDaEliminare').val(id);
        $('#nomeCartellaDaEliminare').text(nomeCartella);
        $('#modalEliminaCartella').modal('show');
    }

    function eseguiEliminazioneCartella() {
        var id = document.getElementById("cartellaDaEliminare").value;

        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"elimina",
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalEliminaCartella').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function eliminaContenutoCartella() {
        var id = document.getElementById("contenutoCartellaDaEliminare").value;

        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"eliminaContenuto",
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalEliminaContenutoCartella').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function eseguiEliminazioneElementiSelezionati() {
        var id = document.getElementById("contenutoSelezionatoCartellaDaEliminare").value;
        var stringaIdCartelle  = document.getElementById("stringaIdCartelle").value;
        var stringaIdDocumenti = document.getElementById("stringaIdDocumenti").value;
        
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"eliminaSelezionati",
                stringaIdCartelle:stringaIdCartelle,
                stringaIdDocumenti:stringaIdDocumenti,
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalEliminaElementiSelezionati').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });    
    }
    
    function apriPopupEliminaElementiSelezionati() {
        var stringaIdCartelle  = "";
        var stringaIdDocumenti = "";
        var stringaElementiDaCancellare = "";
        
        var checkboxCartelle = document.getElementsByClassName('selezionaCartella');
        for(var i in checkboxCartelle) {
            if(checkboxCartelle[i].type === 'checkbox') {
                if(checkboxCartelle[i].checked) {
                    stringaElementiDaCancellare += " " + checkboxCartelle[i].name;
                    stringaIdCartelle  += checkboxCartelle[i].value+"-";
                }
            }
        }
        
        var checkboxDocumenti = document.getElementsByClassName('selezionaDocumento');
        for(var i in checkboxDocumenti) {
            if(checkboxDocumenti[i].type === 'checkbox') {
                if(checkboxDocumenti[i].checked) {
                    stringaElementiDaCancellare += " " + checkboxDocumenti[i].name;
                    stringaIdDocumenti  += checkboxDocumenti[i].value+"-";
                }
            }
        }
        
        document.getElementById("stringaIdCartelle").value  = stringaIdCartelle;
        document.getElementById("stringaIdDocumenti").value = stringaIdDocumenti;
        document.getElementById("elementiSelezionatiPerLeliminazione").innerHTML = stringaElementiDaCancellare;
        $('#modalEliminaElementiSelezionati').modal('show');
    }
    
    /*
     * Funzione che consente di aggiugere una cartella ai preferiti, mostra una popup che 
     * segnala l'avvenuta operazione.
     * 
     * Se viene utilizzata dalla cartella home page, la variabile home deve essere
     * impostata a true (in modo che si aggiorna anche la sheda dei preferiti) altrimenti a false
     */
    function aggiungiCartellaAiPreferiti(idCartella,idUtente,home) {

        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"aggiungiAiPreferiti",
                id:idCartella,
                idUtente:idUtente
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    if(home===true) {
                        aggiornaElencoCartellePreferite();
                    }
                    $('#labelOperazioneCompletata').text("Cartella aggiunta ai preferiti");
                    $('#modalOperazioneCompletata').modal('show');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    
    /*
     * Funzione che consente di rimuovere una cartella dai preferiti, mostra una popup che 
     * segnala l'avvenuta operazione.
     * 
     * Se viene utilizzata dalla cartella home page, la variabile home deve essere
     * impostata a true (in modo che si aggiorna anche la sheda dei preferiti) altrimenti a false
     */
    function rimuoviCartellaDaiPreferiti(idCartella,idUtente,home) {

        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"rimuoviDaiPreferiti",
                id:idCartella,
                idUtente:idUtente
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    if(home===true) {
                        aggiornaElencoCartellePreferite();
                    }
                    $('#labelOperazioneCompletata').text("Cartella rimossa dai preferiti");
                    $('#modalOperazioneCompletata').modal('show');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function apriModalEliminaDocumento(id,nomeDocumento) {
        $('#documentoDaEliminare').val(id);
        $('#nomeDocumentoDaEliminare').text(nomeDocumento);
        $('#modalEliminaDocumento').modal('show');
    }

    function eseguiEliminazioneDocumento() {
        var id = document.getElementById("documentoDaEliminare").value;

        $.ajax({
            type:"POST",
            url:"../controller/controllerDocumenti.php",
            data:{
                operazione:"elimina",
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    document.getElementById("documento"+id).className = "d-none";
                    $('#modalEliminaDocumento').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function copiaNegliAppunti(testoDaCopiare) {
        navigator.clipboard.writeText(testoDaCopiare);
        alert("Testo copiato negli appunti");
    }
    
    /*
     * questa funzione viene usata per associare un'etichetta esistente
     * direttamente dalla pagina del documento
     */
    function associaEtichettaDocumento(idEtichetta,idArticolo) {
        $.ajax({
            type:"POST",
            url:"../controller/controllerDocumenti.php",
            data:{
                operazione:"associaDocumentoEtichetta",
                idEtichetta:idEtichetta,
                id:idArticolo
            },
            success:function(result) {
                if(result!="Il documento è già associato a questa etichetta") {
                    $("#badgeTag"+idEtichetta).addClass("d-none");
                    var vecchioCodice = $("#divTagArticolo").html();

                    if(vecchioCodice.indexOf("stringaNessunTag")>0) {
                        $("#divTagArticolo").html(result);
                    }
                    else {
                        $("#divTagArticolo").html(vecchioCodice+result);
                    }
                }
                else {
                    alert(result);
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    function apriModalRinominaElemento(id,nomeElemento,tipoElemento) {
        $('#elementoDaRinominare').val(id);
        $('#nomeElementoDaRinominare').val(nomeElemento);
        $('#tipoElementoDaRinominare').val(tipoElemento);
        $('#modalRinominaElemento').modal('show');
    }

    function apriModalSpostaElemento(id,tipoElemento,nomeElemento) {
        $('#elementoDaSpostare').val(id);
        $('#tipoElementoDaSpostare').val(tipoElemento);
        document.getElementById("modalSpostaElemento-nomeElementoDaSpostare").innerHTML = nomeElemento;
        $('#modalSpostaElemento').modal('show');
    }
    
    function apriPopupSpostaElementiSelezionati() {
        var stringaIdCartelle  = "";
        var stringaIdDocumenti = "";
        var stringaElementiSelezionatiDaSpostare = "";
        
        var checkboxCartelle = document.getElementsByClassName('selezionaCartella');
        for(var i in checkboxCartelle) {
            if(checkboxCartelle[i].type === 'checkbox') {
                if(checkboxCartelle[i].checked) {
                    stringaElementiSelezionatiDaSpostare += " " + checkboxCartelle[i].name;
                    stringaIdCartelle  += checkboxCartelle[i].value+"-";
                }
            }
        }
        
        var checkboxDocumenti = document.getElementsByClassName('selezionaDocumento');
        for(var i in checkboxDocumenti) {
            if(checkboxDocumenti[i].type === 'checkbox') {
                if(checkboxDocumenti[i].checked) {
                    stringaElementiSelezionatiDaSpostare += " " + checkboxDocumenti[i].name;
                    stringaIdDocumenti  += checkboxDocumenti[i].value+"-";
                }
            }
        }
        
        document.getElementById("stringaIdCartelleDaSpostare").value  = stringaIdCartelle;
        document.getElementById("stringaIdDocumentiDaSpostare").value = stringaIdDocumenti;
        $('#modalSpostaElementiSelezionati').modal('show');
    }
    
    function apriModalCondividiDocumento(id,nomeElemento) {
        $('#documentoDaCondividere').val(id);
        $('#nomeDocumentoDaCondividere').val(nomeElemento);
        $('#modalCondividiDocumento').modal('show');
    }
    
    function rinominaElemento() {
        var id = document.getElementById("elementoDaRinominare").value;
        var tipoElemento = document.getElementById("tipoElementoDaRinominare").value;
        var nomeElemento = document.getElementById("nomeElementoDaRinominare").value;
        
        if(tipoElemento==="cartella") {
            var url = "../controller/controllerCartelle.php";
        }
        else {
            var url = "../controller/controllerDocumenti.php";
        }
        
        $.ajax({
            type:"POST",
            url:url,
            data:{
                operazione:"rinomina",
                nuovoNome:nomeElemento,
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalRinominaElemento').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function apriPopupEliminaUtenzaApi(id,nomeUtenza) {
        document.getElementById("idUtenzaDaEliminare").value = id;
        $('#nomeUtenzaDaEliminare').text(nomeUtenza);
        $('#popupEliminazioneUtenzaApi').modal('show');
    }
    
    function eseguiEliminazioneUtenzaApi(prefisso) {
        var id = document.getElementById("idUtenzaDaEliminare").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerApi.php",
            data:{
                operazione:'elimina',
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById("utenzaApi"+id).className = "d-none";
                    $('#popupEliminazioneUtenzaApi').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    function aggiungiUtenzaApi(prefisso) {
        var nomeUtenza    = document.getElementById("nomeUtenza").value;
        var codiceSegreto = document.getElementById("codiceSegretoUtenza").value;
        
        if(nomeUtenza==="" || codiceSegreto==="") {
            alert("I campi 'nome utenza' e 'codice segreto' non possono essere vuoti");
        }
        else {
            $.ajax({
                type:"POST",
                url:prefisso+"controller/controllerApi.php",
                data:{
                    operazione:"crea",
                    nomeUtenza:nomeUtenza,
                    codiceSegreto:codiceSegreto
                },
                success:function(esito) {
                    if(esito=="ok") {
                        aggiornaDivUtenzeApi(); // questa funzione deve essere definita all'interno della pagina dell'elemento, non può essere generalizzata
                    }
                    else {
                        alert(esito);
                    }
                },
                error: function(xhr,status,error) {
                    alert(status+" "+error);
                }
            });
        }
        
    }
    
    function eseguiModificaUtenzaApi(prefisso) {
        var id            = document.getElementById("idUtenzaDaModificare").value;
        var nomeUtenza    = document.getElementById("modificaNomeUtenza").value;
        var codiceSegreto = document.getElementById("modificaCodiceSegretoUtenza").value;
        
        if(document.getElementById("modificaAttivaApi").checked) {        
            var attiva = "si";
        }
        else {
            var attiva = "no";
        }
        
        if(document.getElementById("modificaPermessiLettura").checked) {
            var permessiLettura = "si";
        }
        else {
            var permessiLettura = "no";
        }
        
        if(document.getElementById("modificaPermessiScrittura").checked) {
            var permessiScrittura = "si";
        }
        else {
            var permessiScrittura = "no";
        }
        
        if(nomeUtenza==="" || codiceSegreto==="") {
            alert("I campi 'nome utenza' e 'codice segreto' non possono essere vuoti");
        }
        else {   
            $.ajax({
                type:"POST",
                url:prefisso+"controller/controllerApi.php",
                data:{
                    operazione:"modifica",
                    id:id,
                    nomeUtenza:nomeUtenza,
                    codiceSegreto:codiceSegreto,
                    attiva:attiva,
                    permessiLettura:permessiLettura,
                    permessiScrittura:permessiScrittura
                },
                success:function(esito) {
                    if(esito=="ok") {
                        aggiornaDivUtenzeApi(); // questa funzione deve essere definita all'interno della pagina dell'elemento, non può essere generalizzata
                        $('#modalModificaUtenzaApi').modal('hide');
                    }
                    else {
                        alert(esito);
                    }
                },
                error: function(xhr,status,error) {
                    alert(status+" "+error);
                }
            });
        }
    }
    
    function creaPaginaApprovazione(idCartella) {
        document.getElementById("cartellaPaginaDaApprovare").value = idCartella;
        document.getElementById("bottoneCreaPaginaApprovazione").className    = "btn btn-primary";
        document.getElementById("formModalCreaPaginaApprovazione").className  = "";
        document.getElementById("esitoCreazionePaginaApprovazione").innerHTML = "";
        
        $('#modalCreaPaginaApprovazione').modal('show');
    }

    function eseguiCreazionePaginaApprovazione() {
        var idCartella              = document.getElementById("cartellaPaginaDaApprovare").value;
        var termineApprovazione     = document.getElementById("termineApprovazione").value;
        var destinatariApprovazione = document.getElementById("destinatariApprovazione").value;
        var testoApprovazione       = document.getElementById("testoApprovazione").value;
        
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"creaPaginaApprovazione",
                id:idCartella,
                termineApprovazione:termineApprovazione,
                destinatariApprovazione:destinatariApprovazione,
                testoApprovazione:testoApprovazione
            },
            success:function(codice) {
                document.getElementById("esitoCreazionePaginaApprovazione").innerHTML = codice;
                document.getElementById("bottoneCreaPaginaApprovazione").className = "d-none";
                document.getElementById("formModalCreaPaginaApprovazione").className = "d-none";
                document.getElementById("termineApprovazione").value     = "";
                document.getElementById("destinatariApprovazione").value = "";
                document.getElementById("testoApprovazione").value       = "";
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function creaPaginaCondivisione(idElemento,tipoElemento) {
        document.getElementById("elementoPaginaDaCondividere").value          = idElemento;
        document.getElementById("tipoElementoPaginaDaCondividere").value      = tipoElemento;
        document.getElementById("bottoneCreaPaginaCondivisione").className    = "btn btn-primary";
        document.getElementById("formModalCreaPaginaCondivisione").className  = "";
        document.getElementById("esitoCreazionePaginaCondivisione").innerHTML = "";
        
        $('#modalCreaPaginaCondivisione').modal('show');
    }
    
    function eseguiCreazionePaginaCondivisione() {
        var idElemento              = document.getElementById("elementoPaginaDaCondividere").value;
        var tipoElemento            = document.getElementById("tipoElementoPaginaDaCondividere").value;
        var termineCondivisione     = document.getElementById("termineCondivisione").value;
        var destinatariCondivisione = document.getElementById("destinatariCondivisione").value;
        var testoCondivisione       = document.getElementById("testoCondivisione").value;
        
        if(tipoElemento === "cartella") {
            var controller = "controllerCartelle.php";
        }
        else {
            var controller = "controllerDocumenti.php";
        }
        
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"creaPaginaCondivisione",
                id:idElemento,
                termineCondivisione:termineCondivisione,
                destinatariCondivisione:destinatariCondivisione,
                testoCondivisione:testoCondivisione
            },
            success:function(codice) {
                document.getElementById("esitoCreazionePaginaCondivisione").innerHTML = codice;
                document.getElementById("bottoneCreaPaginaCondivisione").className = "d-none";
                document.getElementById("formModalCreaPaginaCondivisione").className = "d-none";
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    /*
     * Funzione che esegue la ricerca di una cartella
     */
    function eseguiRicerca() {
        var tipoRicerca = document.getElementById("tipoRicerca").value;
        var cerca = document.getElementById("cerca").value;
        
        if(cerca.length<1 && tipoRicerca!=="Questa cartella") {
            alert("Inserisci qualcosa da cercare");
        }
        if(tipoRicerca==="Questa cartella") {        
            aggiornaContenutoCartella(cerca);
        }
        else {
            document.formRicerca.submit();
        }
    }
    
    /*** FUNZIONI PER LA GESTIONE DEI MESSAGGI ***/

    function inserisciMessaggio(prefisso,idDocumento) {
        var testoMessaggio = document.getElementById("testoMessaggio").value;

        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerMessaggiChat.php",
            data:{
                operazione:"crea",
                testo:testoMessaggio,
                idDocumento:idDocumento
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaDivMessaggi(prefisso,idDocumento);
                    document.getElementById("testoMessaggio").value = "";
                }
                else {
                    alert(esito);
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }

    function aggiornaDivMessaggi(prefisso,idDocumento) {

        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerMessaggiChat.php",
            data:{
                operazione:"stampaChatDocumento",
                idDocumento:idDocumento
            },
            success:function(codice) {
                document.getElementById("messaggiChat").innerHTML = codice;
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    /*** FUNZIONI PER LO SPOSTAMENTO DI FILE E CARTELLE ***/
    function caricaElementiModalSpostamento(tipoModal,cartella) {
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"caricaElementiModalSpostamento",
                tipoModal:tipoModal,
                id:cartella
            },
            success:function(codice) {
                document.getElementById(tipoModal+"-alberoCartelle").innerHTML = codice;
                caricaBreadcrumbModalSpostamento(tipoModal,cartella);
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    function caricaBreadcrumbModalSpostamento(tipoModal,cartella) {
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"stampaBreadcrumbModalSpostamento",
                tipoModal:tipoModal,
                id:cartella
            },
            success:function(codice) {
                document.getElementById(tipoModal+"-breadCrumb").innerHTML = codice;
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    function selezionaDivCartellaSpostamento(tipoModal,div,idCartella) {
        var classiElemento = document.getElementById(div).className;
        var valoreAttuale  = document.getElementById(tipoModal+"-cartellaDestinazione").value;
        
        // se è già stato selezionato un elemento questo deve essere 
        // prima essere rimosso e poi potrà essere selezionato uno nuovo
        if(valoreAttuale>0) {
            var elementiSelezionati = document.getElementsByClassName("p-2 selected");
            for (let i = 0; i < elementiSelezionati.length; i++) {
                elementiSelezionati[i].className = "p-2";
            }
        }
        
        if(classiElemento === "p-2") {
            document.getElementById(div).className = "p-2 selected";
            document.getElementById(tipoModal+"-cartellaDestinazione").value = idCartella;
            document.getElementById(tipoModal+"-pulsanteSposta").removeAttribute("disabled");
        }
        else {
            document.getElementById(div).className = "p-2";
            document.getElementById(tipoModal+"-cartellaDestinazione").value = 0;
            document.getElementById(tipoModal+"-pulsanteSposta").setAttribute("disabled","");
        }
    }
    
    function spostaElemento(idCartella) {
        var id = document.getElementById("elementoDaSpostare").value;
        var tipoElemento = document.getElementById("tipoElementoDaSpostare").value;
        
        if(tipoElemento==="cartella") {
            var url = "../controller/controllerCartelle.php";
        }
        else {
            var url = "../controller/controllerDocumenti.php";
        }
        
        $.ajax({
            type:"POST",
            url:url,
            data:{
                operazione:"sposta",
                idCartella:idCartella,
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalSpostaElemento').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function spostaElementiSelezionati(idCartella) {
        var id = document.getElementById("cartellaElementiSelezionatiDaSpostare").value;
        var stringaIdCartelle  = document.getElementById("stringaIdCartelleDaSpostare").value;
        var stringaIdDocumenti = document.getElementById("stringaIdDocumentiDaSpostare").value;
        
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"spostaElementiSelezionati",
                stringaIdCartelle:stringaIdCartelle,
                stringaIdDocumenti:stringaIdDocumenti,
                idCartella:idCartella,
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalSpostaElementiSelezionati').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function spostaContenutoCartella(idCartella) {
        var id = document.getElementById("contenutoCartellaDaSpostare").value;
        
        $.ajax({
            type:"POST",
            url:"../controller/controllerCartelle.php",
            data:{
                operazione:"spostaContenuto",
                idCartella:idCartella,
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaContenutoCartella("");
                    $('#modalSpostaContenutoCartella').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function eseguiSpostamentoDaPulsante(tipoModal) {
        var idCartella = document.getElementById(tipoModal+"-cartellaDestinazione").value;

        if(tipoModal=="modalSpostaElemento") {
            spostaElemento(idCartella);
        }
        else if(tipoModal=="modalSpostaElementiSelezionati") {
            spostaElementiSelezionati(idCartella);
        }
        else {        
            spostaContenutoCartella(idCartella);
        }
    }
    
    function approvaElementiSelezionati(idOccorrenza) {
        var emailApprovazione  = document.getElementById("emailApprovazione").value;
        var stringaIdDocumenti = "";
        var stringaElementiApprovati = "";
        
        var checkboxDocumenti = document.getElementsByClassName('custom-control-input');
        for(var i in checkboxDocumenti) {
            if(checkboxDocumenti[i].type === 'checkbox') {
                if(checkboxDocumenti[i].checked) {
                    stringaElementiApprovati += " " + checkboxDocumenti[i].name;
                    stringaIdDocumenti  += checkboxDocumenti[i].value+"-";
                }
            }
        }
        
        $.ajax({
            type:"POST",
            url:"controller/controllerApprovazioniUtente.php",
            data:{
                operazione:"approvaElementiSelezionati",
                elementiApprovati:stringaElementiApprovati,
                email:emailApprovazione,
                id:idOccorrenza
            },
            success:function(esito) {
                if(esito=="ok") {
                    location.href = location.href+"&status=200";
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }